#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ProlongedTransfusionReport : BaseTest 
	{
		private const int ProlongedTransfusionThresholdMinutes = 30;
		private DateTime _divisionNow;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_divisionNow = VbecsDateTime.GetDivisionCurrentDateTime();
		}

		//TODO: Remove blank constructor from DAL.ProlongedTransfusionReport - uneeded and not used

		[Test]
		public void GetReportData_Pass_1()
		{
			Assert.IsNotNull( GetWideDateRangeSortedReport( COMMON.ProlongedTransfusionTimeReportSortOrder.ReverseChronological ) );
		}

		[Test]
		public void GetReportData_Pass_2()
		{
			DataTable _testReportData = ProlongedTransfusionReport.GetReportData( DateTime.Now, DateTime.Now.AddYears( -1 ), 30, COMMON.ProlongedTransfusionTimeReportSortOrder.ReverseChronological );
			Assert.AreEqual( 0, _testReportData.Rows.Count );
		}

		[Test]
		public void GetReportData_Pass_3()
		{
			DataTable _reportData = GetWideDateRangeSortedReport( COMMON.ProlongedTransfusionTimeReportSortOrder.ReverseChronological );

			for( int _currentRowIndex = 1, _previousRowIndex = 0; _currentRowIndex < _reportData.Rows.Count; _currentRowIndex++, _previousRowIndex++ )
				Assert.IsTrue( Convert.ToDateTime( _reportData.Rows[_currentRowIndex][ TABLES.IssuedUnit.IssueDateTime ] ) <= Convert.ToDateTime( _reportData.Rows[_previousRowIndex][ TABLES.IssuedUnit.IssueDateTime ] ), "Prolonged transfusion time report was not sorted in reverse chronological order as expected." );

			Assert.IsTrue(true, "Success");
		}

		[Test]
		public void GetReportData_Pass_4()
		{
			DataTable _reportData = GetWideDateRangeSortedReport( COMMON.ProlongedTransfusionTimeReportSortOrder.IssueToLocation );

			for( int _currentRowIndex = 1, _previousRowIndex = 0; _currentRowIndex < _reportData.Rows.Count; _currentRowIndex++, _previousRowIndex++ )
			{
				int _comparisonResult = Convert.ToString( _reportData.Rows[_currentRowIndex][ TABLES.IssuedUnit.IssueToLocationName ] ).CompareTo( Convert.ToString( _reportData.Rows[_previousRowIndex][ TABLES.IssuedUnit.IssueToLocationName ] ) );
				Assert.IsTrue( _comparisonResult >= 0, "Prolonged transfusion time report was not sorted in issue-to location order as expected." );
			}

			Assert.IsTrue(true, "Success");
		}

		private DataTable GetWideDateRangeSortedReport( COMMON.ProlongedTransfusionTimeReportSortOrder sortOrder )
		{			
			return ProlongedTransfusionReport.GetReportData( _divisionNow.AddYears( -100 ), _divisionNow, ProlongedTransfusionThresholdMinutes, sortOrder );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportData_Fail(){}

		[Test]
		public void GetReportCountEstimate_Pass_1()
		{
			Assert.IsTrue( ProlongedTransfusionReport.GetReportCountEstimate( _divisionNow.AddYears( -100 ), _divisionNow, ProlongedTransfusionThresholdMinutes ) >= 0 );
		}

		[Test]
		public void GetReportCountEstimate_Pass_2()
		{
			Assert.AreEqual( 0, ProlongedTransfusionReport.GetReportCountEstimate( _divisionNow.AddYears( 100 ), _divisionNow, ProlongedTransfusionThresholdMinutes ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportCountEstimate_Fail() {}
	}
}
#endif
